import Vue from 'vue'
import ElementUI from 'element-ui';
import axios from 'axios'
import localStorage from '../vuex/localStorage'
import { router } from '../routes'
import qs from 'qs';
import {rootUrl} from '@/config'
let apiPrefix = process.env.NODE_ENV === 'production' ? '/' : '/api';
let AxiosIns = axios.create({
	baseURL: rootUrl,
	timeout: 5000,
	transformRequest: [data => {
		return qs.stringify(data)
	}],
	headers: { 'Content-Type': 'application/x-www-form-urlencoded;charset=utf-8' },
	// withCredentials: true
})

let timer = [];
let delay = 300;
let loading = null;
let options = {
	lock: true,
	text: '拼命加载中',
	background: 'rgba(0, 0, 0, 0)'
}
let julietJava = "juliet-java";

AxiosIns.interceptors.request.use((config) => {
	// config.headers[julietJava]=localStorage.$getLocalStorageByName(julietJava);
	loading = ElementUI.Loading.service(options);
	timer.push(setTimeout(() => {
	}, delay))
	return config;
})

AxiosIns.interceptors.response.use((response) => {
	if (response.headers[julietJava]){
		localStorage.$setLocalStorageByName(julietJava,response.headers[julietJava]);
	}
	for (let t of timer) {
		clearTimeout(t);
	}
	loading.close()
	try {//使用try catch是因为：后台服务器挂掉返回的并不是一个object并不能正确捕捉到错误信息
		if (response.data && response.data.success !== true) {
			let msg = Array.isArray(response.data.errMsg) ? response.data.errMsg[0] : response.data.errMsg;
			ElementUI.Message({
				message: msg || '操作失败',
				type: 'warning',
				showClose: true,
			});
			if (response.data.errCode === "10002") { // cookie验证验权失败
				setTimeout(() => {
					localStorage.$setLocalStorageByName('user', {}); //清空用户缓存
					router.push({name: 'login'})
				}, 2000)
			}
		}
	} catch (e) {
		console.log(e);
	}
	return response.data;
}, (error) => {
	for (let t of timer) {
		clearTimeout(t);
	}
	loading.close();
	try {
		// if (error.response.data.Code !== 0) {
		// 	let msg = typeof error.response.data === "string" ? error.response.data : error.response.data.Message
		// 	if (msg !== '对不起,您没有配置权限菜单！') {
		// 		ElementUI.Message({
		// 			message: msg || '操作失败',
		// 			type: 'warning',
		// 			showClose: true
		// 		});
		// 	}
		// }
		// 请求授权失败则重新跳转到登陆页
		if (error.response.data.Code === 401) {
			setTimeout(() => {
				router.push({
					name: 'login'
				})
			}, 2000)
		}
	} catch (e) {
		console.log(e);
	}
	return Promise.reject(error);
})
Vue.prototype.axios = AxiosIns;
