var path = require('path')
var utils = require('./utils')
var config = require('../config')
var vueLoaderConfig = require('./vue-loader.conf')

function resolve(dir) {
  return path.join(__dirname, '..', dir)
}

module.exports = {
  entry: {
    app: './src/main.js'
	},
	externals: {
		'vue': 'Vue',
		'vue-router': 'VueRouter',
		'element-ui': 'ELEMENT',
		'vuex': 'Vuex',
		'axios': 'axios',
    'echarts': 'echarts'
		// 'CKEditor':'CKEditor',
		// 'DecoupledEditor':'DecoupledEditor'
	},
  output: {
    path: config.build.assetsRoot,
    filename: '[name].js',
    publicPath: process.env.NODE_ENV === 'production'
      ? config.build.assetsPublicPath
      : config.dev.assetsPublicPath
  },
  resolve: {
    extensions: ['.js', '.vue', '.json'],
    alias: {
      'vue$': 'vue/dist/vue.esm.js',
			'@': resolve('src'),
			'assets': resolve('src/assets'),
			'scss_vars': '@/styles/vars.scss'
    }
  },
  module: {
    rules: [
      {
        test: /\.vue$/,
        loader: 'vue-loader',
        options: vueLoaderConfig
      },
      {
        test: /\.js$/,
        loader: 'babel-loader',
        include: [resolve('src'), resolve('test')]
			},
			{
				test: /\.(png|jpe?g|gif|svg)(\?.*)?$/,
				use:[
					{
					loader: 'url-loader',
					options: {
						limit: 10000,
						name: utils.assetsPath('img/[name].[hash:7].[ext]')
						}
					},
					{
						loader: 'image-webpack-loader',// 压缩图片
						options: {
							disable: true
						}
					}
				]
			},
      // {
      //   test: /\.(png|jpe?g|gif|svg)(\?.*)?$/,
      //   loader: 'url-loader',
      //   options: {
      //     limit: 10000,
      //     name: utils.assetsPath('img/[name].[hash:7].[ext]')
      //   }
      // },
      {
        test: /\.(woff2?|eot|ttf|otf)(\?.*)?$/,
        loader: 'url-loader',
        options: {
          limit: 10000,
          name: utils.assetsPath('fonts/[name].[hash:7].[ext]')
        }
			}
    ]
  }
}
