// import Vue from 'vue'
// import ELEMENT from 'element-ui';
// import axios from 'axios'
import localStorage from '../vuex/localStorage'
import { router } from '../router'
import qs from 'qs';
import {rootUrl} from '@/config'
let apiPrefix = process.env.NODE_ENV === 'production' ? '/' : '/api';
let AxiosIns = axios.create({
	baseURL: rootUrl,
	timeout: 50000,
	transformRequest: [data => {
	if(data instanceof FormData){
		return data
	}else{
		return qs.stringify(data)
	}
	}],
	headers: { 'Content-Type': 'application/x-www-form-urlencoded;charset=utf-8' },
	withCredentials: true
})

let timer = [];
let delay = 300;
let loading = null;
let options = {
	lock: true,
	text: '拼命加载中',
	background: 'rgba(0, 0, 0, 0.2)',
	target: "#app",
}

AxiosIns.interceptors.request.use((config) => {
	if (loading == null) {
		loading = ELEMENT.Loading.service(options);
	}
	timer.push(setTimeout(() => {
	}, delay))
	return config;
})

AxiosIns.interceptors.response.use((response) => {
	for (let t of timer) {
		clearTimeout(t);
	}
	if (loading != null) {
		loading.close();
		loading = null;
	}
	try {//使用try catch是因为：后台服务器挂掉返回的并不是一个object并不能正确捕捉到错误信息
		if (response.data && response.data.success !== true) {
			let msg = Array.isArray(response.data.errMsg) ? response.data.errMsg[0] : response.data.errMsg;
			let code = Array.isArray(response.data.errCode) ? response.data.errCode[0] : response.data.errCode;
			ELEMENT.Message({
				message: msg ? msg : code || '操作失败',
				type: 'warning',
				showClose: true,
			});
			if (msg == "REQUEST_TOKEN") { // cookie验证验权失败
				localStorage.$setLocalStorageByName('user', {}); //清空用户缓存
				setTimeout(() => {
					router.push({path: '/login'})
				}, 1000)
			}
		}
	} catch (e) {

	}
	return response.data;
}, (error) => {
	for (let t of timer) {
		clearTimeout(t);
	}
	// loading.close();
	try {
		// console.log(error.response.status)
		// if (error.response.data.Code !== 0) {
		// 	let msg = typeof error.response.data === "string" ? error.response.data : error.response.data.Message
		// 	if (msg !== '对不起,您没有配置权限菜单！') {
		// 		ELEMENT.Message({
		// 			message: msg || '操作失败',
		// 			type: 'warning',
		// 			showClose: true
		// 		});
		// 	}
		// }
		// 请求授权失败则重新跳转到登陆页
		// if (error.response.data.Code === 401) {
			// setTimeout(() => {
				// router.push({
				// 	path: '/login'
				// })
			// }, 1000)
		// }
		let message=''
		if(error&&error.response){
			loading.close();
			loading = null;
			switch(error.response.status){
				case 400:
				message='错误请求'
				break;
				case 404:
				message='请求错误，未找到该资源'
				break;
				case 500:
				message='服务器出错'
				break;
				default:
				message='网络错误'
			}
			ELEMENT.Message({
				message: message,
				type: 'warning',
				showClose: true,
			});
		}else{
			loading.close();
			loading = null;
			ELEMENT.Message({
				message: '后端接口出现异常',
				type: 'warning'
			});
			// router.push({
			// 	path: '/login'
			// })
		}
	} catch (e) {
		console.log(e);
		// loading.close();
		loading = null;
	}
	return Promise.reject(error);
})
Vue.prototype.axios = AxiosIns;
