// import Vue from 'vue'
// import VueRouter from 'vue-router'
// import 'vueConfig'
import warehouseConfiguration from './warehouseConfiguration'
import logisticsConfiguration from './logisticsConfiguration'
import deliveryChannelConfiguration from './deliveryChannelConfiguration'
const login = resolve => require(['@/views/Login'], resolve);
import index from './index/index'
// const parent = resolve => require(['@/components/parent'], resolve);//子页面
const Home = resolve => require(['@/views/Home'], resolve); //子页面


Vue.use(VueRouter);
const routes = [{ // 404
        path: '*',
        component: login
    },
    {
        path: '/login',
        component: login,
        name: 'login',
        hidden: true
		},
    // 主页面
    {
        path: '/home',
        // redirect: '/',
        name: 'home',
        component: Home,
        children: [].concat(index,warehouseConfiguration,logisticsConfiguration,deliveryChannelConfiguration)
    },
].reverse();
export const router = new VueRouter({
    routes,
    mode: 'history',
})
router.beforeEach((to, from, next) => {
    if (to.path == '/login') {
        localStorage.removeItem('user');
    }
    let user = JSON.parse(localStorage.getItem('user'));
    if (!user && to.path != '/login') {
        // next({ path: '/login' })
				next()
    } else {
			if(from.meta.isChildren&&!to.meta.isChildren){
				from.meta.keepAlive = false
				to.meta.keepAlive = true
			}else if(to.meta.isChildren&&!from.meta.isChildren){
				to.meta.keepAlive = false
			}
			else{
				to.meta.keepAlive = true
			}
        next()
    }
})