var SIGN_REGEXP = /([yMdhsm])(\1*)/g;
var DEFAULT_PATTERN = 'yyyy-MM-dd';
function padding(s, len) {
    var len = len - (s + '').length;
    for (var i = 0; i < len; i++) { s = '0' + s; }
    return s;
};

import OSS from 'ali-oss';

export default {
    getQueryStringByName: function (name) {
        var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
        var r = window.location.search.substr(1).match(reg);
        var context = "";
        if (r != null)
            context = r[2];
        reg = null;
        r = null;
        return context == null || context == "" || context == "undefined" ? "" : context;
    },
    formatDate: {
        format: function (date, pattern) {
            pattern = pattern || DEFAULT_PATTERN;
            return pattern.replace(SIGN_REGEXP, function ($0) {
                switch ($0.charAt(0)) {
                    case 'y': return padding(date.getFullYear(), $0.length);
                    case 'M': return padding(date.getMonth() + 1, $0.length);
                    case 'd': return padding(date.getDate(), $0.length);
                    case 'w': return date.getDay() + 1;
                    case 'h': return padding(date.getHours(), $0.length);
                    case 'm': return padding(date.getMinutes(), $0.length);
                    case 's': return padding(date.getSeconds(), $0.length);
                }
            });
        },
        parse: function (dateString, pattern) {
            var matchs1 = pattern.match(SIGN_REGEXP);
            var matchs2 = dateString.match(/(\d)+/g);
            if (matchs1.length == matchs2.length) {
                var _date = new Date(1970, 0, 1);
                for (var i = 0; i < matchs1.length; i++) {
                    var _int = parseInt(matchs2[i]);
                    var sign = matchs1[i];
                    switch (sign.charAt(0)) {
                        case 'y': _date.setFullYear(_int); break;
                        case 'M': _date.setMonth(_int - 1); break;
                        case 'd': _date.setDate(_int); break;
                        case 'h': _date.setHours(_int); break;
                        case 'm': _date.setMinutes(_int); break;
                        case 's': _date.setSeconds(_int); break;
                    }
                }
                return _date;
            }
            return null;
        }

		},
		getTime: function (n,callback) {
			console.log(typeof callback)
      var now = new Date();
      var year = now.getFullYear();
      //因为月份是从0开始的,所以获取这个月的月份数要加1才行
      var month = now.getMonth() + 1;
      var date = now.getDate();
      var day = now.getDay();
      //判断是否为周日,如果不是的话,就让今天的day-1(例如星期二就是2-1)
      if (day !== 0) {
        n = n + (day - 1);
      } else {
        n = n + day;
      }
      if (day) {
        //这个判断是为了解决跨年的问题
        if (month > 1) {
          month = month;
        }
        //这个判断是为了解决跨年的问题,月份是从0开始的
        else {
          year = year - 1;
          month = 12;
        }
      }
      now.setDate(now.getDate() - n);
      year = now.getFullYear();
      month = now.getMonth() + 1;
      date = now.getDate();
      let s =
        year +
        "-" +
        (month < 10 ? "0" + month : month) +
        "-" +
        (date < 10 ? "0" + date : date);
      this.value1 = s;
      callback(s);
    },
		handleselect(key,_this,type,name) {
			let getCurSide=_this.getCurSide?_this.getCurSide:JSON.parse(localStorage.getItem('menuTree'))
			let isHas = _this.dynamicTags.some((item) => {
					return item.path == key
			})
			if(type==1){
				getCurSide.map((item) => {
					item.children.map((v) => {
							if (v.path === key && !isHas) {
								_this.dynamicTags.map((m) => {
											return m.type = 'info'
									})
								_this.dynamicTags.push(v)
							}
					})
				})
			}else{
				if(!isHas){
					_this.dynamicTags.push({name,path:key,type:'info'})
				}
			}
			if (_this.dynamicTags.length > 1) {
				_this.dynamicTags.map((m) => {
							if (key == m.path) {
								_this.$set(m, 'type', '')
							} else {
								_this.$set(m, 'type', 'info')
							}
					})
			}
			_this.$store.commit('getTopMenu', _this.dynamicTags);
		},
    export(url, param, _this){
        let obj = _this.$el;
        obj.setAttribute("class", "el-loading-parent--relative");
        let loadDiv = document.createElement('div');
        let loadDivContent = '<div class="el-loading-mask" style=""><div class="el-loading-spinner"><svg viewBox="25 25 50 50" class="circular"><circle cx="50" cy="50" r="20" fill="none" class="path"></circle></svg><!----></div></div>';
        loadDiv.innerHTML = loadDivContent;
        obj.appendChild(loadDiv);
        let notify = _this.$notify({
            title: '下载中',
            dangerouslyUseHTMLString: true,
            message: '',
            type: 'info',
            duration: 0
        });
        _this.axios({
            url: url,
            data: param,
            method: 'post'
        }).then(res => {
            if (res.success){
                notify.title = "下载完成";
                notify.type = 'success';
                notify.message = '<strong><a style="text-decoration: none;" href="'+res.module+'">点击获取</a></strong>';
            } else {
                notify.title = "下载失败";
                notify.type = 'error';
            }
            obj.removeAttribute("class");
            obj.removeChild(loadDiv);
        })
    },
    client(data) {
        console.log(JSON.stringify(data));
        return new OSS({
            region: data.region,
            accessKeyId: data.accessKeyId,
            accessKeySecret: data.accessKeySecret,
            bucket: data.bucket
        });
    },
};
